<?php
/*********************************************
  CPGNuCalendar
  ********************************************
  Copyright 2005 by Kris Henneman
  
  Original highly modified code ported from an early 2003 
  version of WebCalendar by http://webcalendar.sourceforge.net
  to PHP-Nuke.  It has since been ported to CPG-Nuke.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  CPGNuCalendar is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  $Id: cpg_inst.php,v 1.3 2007/10/25 07:43:27 Phoenix Exp $
  $Revision: 1.3 $
  $Author: Phoenix $
  $Date: 2007/10/25 07:43:27 $
**********************************************/
if (!defined('ADMIN_MOD_INSTALL')) { exit; }
class CPGNuCalendar {
	var $radmin;
	var $version;
	var $modname;
	var $description;
	var $author;
	var $website;
	var $oldprefix;
	var $dbtables;
	function CPGNuCalendar() {
		global $prefix;
		$this->radmin = true;
		$this->version = '2.0.6';
		$this->modname = 'CPGNuCalendar';
		$this->description = 'Provide an event calendar';
		$this->author = 'Kris Henneman';
		$this->website = 'doublinggap.org';
		$this->oldprefix = 'calendar';
		$this->prefix = strtolower(basename(dirname(__FILE__)));
		$this->dbtables = array($this->prefix,  $this->prefix.'_categories', $this->prefix.'_repeat', $this->prefix.'_repeat_cancel', $this->prefix.'_repeat_desc');
	}
	function install() {
		global $installer, $db, $prefix;
		$tables = $db->list_tables();

		if (array_key_exists($prefix."_".strtolower($this->oldprefix), $tables) && 
			array_key_exists($prefix."_".strtolower($this->oldprefix).'_repeat', $tables) &&
			array_key_exists($prefix."_".strtolower($this->oldprefix).'_repeat_cancel', $tables) &&
			array_key_exists($prefix."_".strtolower($this->oldprefix).'_repeat_desc', $tables) ) {
			
			$this->upgrade("1.09");
		} else {
			$installer->add_query('CREATE', $this->prefix, '
				eid int(11) NOT NULL auto_increment,
				creator varchar(25) NOT NULL,
				date int(11) NOT NULL default "0",
				time int(11) default NULL,
				mod_date int(11) default NULL,
				mod_time int(11) default NULL,
				duration int(11) NOT NULL default "0",
				priority int(11) default "2",
				type char(1) default "E",
				view int(1) NOT NULL default "0",
				name varchar(80) NOT NULL,
				description text,
				image varchar(30) default "circle.gif",
				approved int(11) NOT NULL default 0,
				category int(11) NOT NULL default 0,
				PRIMARY KEY  (eid)', $this->prefix);
			$installer->add_query('CREATE', $this->prefix.'_repeat', '
				eid int(11) NOT NULL default "0",
				type varchar(20) default NULL,
				end int(11) default NULL,
				frequency int(11) default "1",
				days varchar(30) default NULL,
				PRIMARY KEY  (eid)', $this->prefix.'_repeat');
			$installer->add_query('CREATE', $this->prefix.'_repeat_cancel', '
				eid int(11) NOT NULL default "0",
				date int(11) NOT NULL default "0",
				PRIMARY KEY  (eid,date)', $this->prefix.'_repeat_cancel');
			$installer->add_query('CREATE', $this->prefix.'_repeat_desc', '
				eid int(11) NOT NULL default "0",
				date int(11) NOT NULL default "0",
				name varchar(80) NOT NULL,
				description text,
				PRIMARY KEY  (eid,date)', $this->prefix.'_repeat_desc');
			$installer->add_query('CREATE', $this->prefix.'_categories', '
				catid int(11) NOT NULL auto_increment,
				title varchar(25) NOT NULL,
				image varchar(30) default "blank.gif",
				priority int(1) default "2",
				display int(1) default "0",
				PRIMARY KEY  (catid)', $this->prefix.'_categories');

			$installer->add_query('INSERT', $this->prefix, '"1","CPGNuCalendar","19000704","-1","20050719","81730","0","1","R","0","Independence Day","Independence Day","flag.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"2","CPGNuCalendar","19000101","-1","20050719","81822","0","1","R","0","New Year\'s Day","New Year\'s Day","streamers.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"3","CPGNuCalendar","19860120","-1","20050719","82429","0","1","R","0","Martin Luther King Day","Martin Luther King Day","martinlutherking.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"4","CPGNuCalendar","19370120","-1","20050718","135414","0","1","R","0","Inauguration Day","Inauguration Day","flag.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"5","CPGNuCalendar","19710215","-1","20050718","140602","0","1","R","0","George Washington\'s Birthday","George Washington\'s Birthday","georgewashington.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"6","CPGNuCalendar","19500520","-1","20050719","90240","0","1","R","0","Armed Forces Day","Armed Forces Day","flag.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"7","CPGNuCalendar","19710531","-1","20050718","141053","0","1","R","0","Memorial Day","Memorial Day","flagribbon.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"8","CPGNuCalendar","19500614","-1","20050719","90629","0","1","R","0","Flag Day","Flag Day","flag.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"9","CPGNuCalendar","19000903","-1","20050719","90928","0","1","R","0","Labor Day","Labor Day","laborday.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"10","CPGNuCalendar","19541111","-1","20050719","91340","0","1","R","0","Veterans Day","Veterans Day","veteransday.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"11","CPGNuCalendar","19001122","-1","20050719","73543","0","1","R","0","Thanksgiving Day","Thanksgiving Day","turkey.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"12","CPGNuCalendar","19001225","-1","20050719","91408","0","1","R","0","Christmas Day","Christmas Day","star.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"13","CPGNuCalendar","20050403","-1","20050707","83545","0","1","R","0","Daylight Saving time begins","Daylight Saving time begins","clock.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"14","CPGNuCalendar","20051030","-1","20050707","83633","0","1","R","0","Daylight Saving Time ends","Daylight Saving Time ends","clock.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"15","CPGNuCalendar","19000202","-1","20050719","85342","0","1","R","0","Groundhog Day","Groundhog Day","groundhog.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"16","CPGNuCalendar","19000212","-1","20050719","85235","0","1","R","0","Lincoln\'s Birthday","Lincoln\'s Birthday","abelincoln.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"17","CPGNuCalendar","19000214","-1","20050719","85021","0","1","R","0","Valentine\'s Day","Valentine\'s Day","heart.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"18","CPGNuCalendar","19000317","-1","20050719","85604","0","1","R","0","St. Patrick\'s Day","St. Patrick\'s Day","stpatrickshat.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"19","CPGNuCalendar","20050401","-1","20050719","80949","0","1","R","0","April Fool\'s Day","April Fools\'s Day","aprilfools.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"20","CPGNuCalendar","19700422","-1","20050719","85746","0","1","R","0","Earth Day","Earth Day","earth.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"21","CPGNuCalendar","19140510","-1","20050719","85922","0","1","R","0","Mothers\' Day","Mothers\' Day","flowers.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"22","CPGNuCalendar","19660619","-1","20050719","90759","0","1","R","0","Fathers\' Day","Fathers\' Day","dad.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"23","CPGNuCalendar","19001031","-1","20050719","91103","0","1","R","0","Halloween","Halloween","pumpkin.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"24","CPGNuCalendar","19000415","-1","20050719","74032","0","1","R","0","Easter","Easter","cross.gif", 0, 2');
			$installer->add_query('INSERT', $this->prefix, '"25","CPGNuCalendar","19711011","-1","20050718","151227","0","1","R","0","Columbus Day","Columbus Day","ship.gif", 0, 2');

			$installer->add_query('INSERT', $this->prefix.'_repeat', '"1","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"2","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"3","yearlyByDay",NULL,"1","Third,Monday,1"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"4","yearly",NULL,"4","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"5","yearlyByDay",NULL,"1","Third,Monday,2"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"6","yearlyByDay",NULL,"1","Third,Saturday,5"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"7","yearlyByDay",NULL,"1","Last,Monday,5"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"8","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"9","yearlyByDay",NULL,"1","First,Monday,9"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"10","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"11","yearlyByDay",NULL,"1","Fourth,Thursday,11"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"12","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"13","yearlyByDay",NULL,"1","First,Sunday,4"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"14","yearlyByDay",NULL,"1","Last,Sunday,10"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"15","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"16","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"17","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"18","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"19","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"20","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"21","yearlyByDay",NULL,"1","+1,Sunday,5"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"22","yearlyByDay",NULL,"1","Third,Sunday,6"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"23","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"24","yearly",NULL,"1","nnnnnnn"');
			$installer->add_query('INSERT', $this->prefix.'_repeat', '"25","yearlyByDay",NULL,"1","+1,Monday,10"');

			$installer->add_query('INSERT', $this->prefix.'_categories', '"1", "General", "circle.gif", 2, 1');
			$installer->add_query('INSERT', $this->prefix.'_categories', '"2", "Holiday", "circle.gif", 1, 0');
			$installer->add_query('INSERT', $this->prefix.'_categories', '"3", "Birthday", "birthday.gif", 1, 1');
			$installer->add_query('INSERT', $this->prefix.'_categories', '"4", "Anniversary", "anniversary.gif", 1, 1');

			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "version", "'.$this->version.'"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "year_columns", "3"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "default_view", "month"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "week_start_day", "0"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "time_format", "12"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "show_weekly_link", "1"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "show_time", "0"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "start_year", "1900"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "workday_start", "8"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "workday_end", "17"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "update", "2"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "admin_approval", "1"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "admin_events", "2"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "default_category", "General"');
			$installer->add_query('INSERT', 'config_custom', '"cpgnucalendar", "block_module_name", "'.basename(dirname(__FILE__)).'"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_upcoming_days", "10"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_upcoming_scroll", "1"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_upcoming_scroll_speed", "150"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_month_highlight_days", "1"');

			Cache::array_delete('MAIN_CFG');

		}

//		$this->upgrade($this->version);
		return true;
	}
	function uninstall() {
		global $installer;
		$installer->add_query('DROP', $this->prefix);
		$installer->add_query('DROP', $this->prefix.'_categories');
		$installer->add_query('DROP', $this->prefix.'_repeat');
		$installer->add_query('DROP', $this->prefix.'_repeat_cancel');
		$installer->add_query('DROP', $this->prefix.'_repeat_desc');
		$installer->add_query('DELETE', 'config_custom', 'cfg_name = "'.$this->prefix.'"');
		$installer->add_query('DELETE', 'config_custom', 'cfg_name = "cpgnucalendar"');//for block_module_name
		return true;
	}
	function upgrade($prev_version) {
		global $installer, $userinfo, $db, $prefix;

		$dprev_version = substr($prev_version, 0, 2) . str_replace(".", "", substr($prev_version, 2));


		if ($dprev_version == 1.09) {
			if ($this->oldprefix != $this->prefix) {
				$installer->add_query('REN', $this->oldprefix, $this->prefix);
				$installer->add_query('REN', $this->oldprefix.'_repeat', $this->prefix.'_repeat');
				$installer->add_query('REN', $this->oldprefix.'_repeat_cancel', $this->prefix.'_repeat_cancel');
				$installer->add_query('REN', $this->oldprefix.'_repeat_desc', $this->prefix.'_repeat_desc');
			}

			$installer->add_query('ADD', $this->prefix, 'COLUMN approved int(11) NOT NULL default 0');
			$installer->add_query('ADD', $this->prefix, 'COLUMN category int(11) NOT NULL default 0');

			$installer->add_query('UPDATE', $this->prefix, 'category = 1 where substring(TYPE, 2, 1) = "G"');
			$installer->add_query('UPDATE', $this->prefix, 'category = 2 where substring(TYPE, 2, 1) = "H"');
			$installer->add_query('UPDATE', $this->prefix, 'category = 3 where substring(TYPE, 2, 1) = "B"');
			$installer->add_query('UPDATE', $this->prefix, 'category = 4 where substring(TYPE, 2, 1) = "A"');
			$installer->add_query('UPDATE', $this->prefix, 'type = "R" where substring(TYPE, 1, 1) = "R"');
			$installer->add_query('UPDATE', $this->prefix, 'type = "E" where substring(TYPE, 1, 1) = "E"');
			$installer->add_query('UPDATE', $this->prefix, 'creator = "'.$this->prefix.'" where eid <= 25');
			$installer->add_query('UPDATE', $this->prefix, 'creator = "'.$userinfo['username'].'" where eid > 25');

			$installer->add_query('CHANGE', $this->prefix, 'type type char(1) default "E"');

			$installer->add_query('CREATE', $this->prefix.'_categories', '
				catid int(11) NOT NULL auto_increment,
				title varchar(25) NOT NULL,
				image varchar(30) default "blank.gif",
				priority int(1) default "2",
				display int(1) default "0",
				PRIMARY KEY  (catid)', $this->prefix.'_categories');
			$installer->add_query('INSERT', $this->prefix.'_categories', '"", "General", "circle.gif", 2, 1');
			$installer->add_query('INSERT', $this->prefix.'_categories', '"", "Holiday", "circle.gif", 1, 0');
			$installer->add_query('INSERT', $this->prefix.'_categories', '"", "Birthday", "birthday.gif", 1, 1');
			$installer->add_query('INSERT', $this->prefix.'_categories', '"", "Anniversary", "anniversary.gif", 1, 1');

			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "version", "'.$this->version.'"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "year_columns", "3"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "default_view", "month"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "week_start_day", "0"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "time_format", "12"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "show_weekly_link", "1"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "show_time", "0"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "start_year", "1900"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "workday_start", "8"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "workday_end", "17"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "update", "2"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "admin_approval", "1"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "default_category", "General"');
			$installer->add_query('INSERT', 'config_custom', '"cpgnucalendar", "block_module_name", "'.basename(dirname(__FILE__)).'"');
		}

		if ($dprev_version < 2.04) {
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_upcoming_days", "10"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_upcoming_scroll", "1"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_upcoming_scroll_speed", "150"');
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "block_month_highlight_days", "1"');
		}

//		if (version_compare($prev_version, '2.0.6', '<')) {
		if ($dprev_version < 2.06) {
			$installer->add_query('INSERT', 'config_custom', '"'.$this->prefix.'", "admin_events", "2"');
		}

		$exists = $db->sql_query("SELECT custom_title FROM ".$prefix."_config_custom WHERE cfg_name = 'cpgnucalendar' AND cfg_field = 'block_module_name'", SQL_NUM, __FILE__, __LINE__);
		if ($db->sql_numrows($exists) > 0) {
			$installer->add_query('UPDATE', 'config_custom', 'cfg_value = "'.basename(dirname(__FILE__)).'" WHERE cfg_name = "cpgnucalendar" AND cfg_field = "block_module_name"');
		} else {
			$installer->add_query('INSERT', 'config_custom', '"cpgnucalendar", "block_module_name", "'.basename(dirname(__FILE__)).'"');
		}

		$installer->add_query('UPDATE', 'config_custom', 'cfg_value = "'.$this->version.'" WHERE cfg_name = "'.$this->prefix.'" AND cfg_field = "version"');

		Cache::array_delete('MAIN_CFG');

		return true;
	}
}
