<?php
/*********************************************
  CPGNuCalendar
  ********************************************
  Copyright 2005 by Kris Henneman
  
  Original highly modified code ported from an early 2003 
  version of WebCalendar by http://webcalendar.sourceforge.net
  to PHP-Nuke.  It has since been ported to CPG-Nuke.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  CPGNuCalendar is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  $Id: index.inc,v 1.3 2007/10/25 07:43:27 Phoenix Exp $
  $RCSfile: index.inc,v $
  $Revision: 1.3 $
  $Author: Phoenix $
  $Date: 2007/10/25 07:43:27 $
**********************************************/

if (!defined('ADMIN_PAGES')) { exit; }
if (!can_admin($module_name)) { die('Access Denied'); }

global $MAIN_CFG, $modheader, $CPG_SESS;

//$module_name = basename(dirname(dirname(__FILE__)));
$cal_prefix = $prefix.'_'.strtolower($module_name);
$cal_config = $MAIN_CFG[strtolower($module_name)];

require_once("modules/$module_name/includes/functions.inc");

$pagetitle .= ' '._BC_DELIM.' '.$cal_module_title;

if (file_exists("modules/$module_name/style/".$CPG_SESS['theme']."style.css")) 
	$modheader .= "\n<link rel=\"stylesheet\" href=\"modules/$module_name/style/".$CPG_SESS['theme']."style.css\" type=\"text/css\" />";
else
	$modheader .= "\n<link rel=\"stylesheet\" href=\"modules/$module_name/style/style.css\" type=\"text/css\" />";

$modheader .= "\n<script type=\"text/javascript\" src=\"modules/$module_name/js/calendar.js\"></script>";

function view_admin($catid, $menu, $show) {
	global $module_name, $cal_config, $db, $cal_prefix, $bgcolor2;
	require_once('header.php');

	OpenTable();

	$pending = $db->sql_numrows($db->sql_query ( "SELECT eid FROM ". $cal_prefix ." WHERE approved = 0"));

	echo "<b>" . $module_name . " " . $cal_config['version'] . " " . _CALCONFIGMANAGER. "</b><br />"
		.($menu == 1 ? "<b>"._CALADMIN."</b>" : "<a href=\"".adminlink($module_name. "&view=admin&menu=1")."\">"._CALADMIN."</a>"). " | "
		.($menu == 2 ? "<b>"._CALBLOCKADMIN."</b>" : "<a href=\"".adminlink($module_name. "&view=admin&menu=2")."\">"._CALBLOCKADMIN."</a>"). " | "
		.($menu == 3 ? "<b>"._CATADMIN_ADD."</b>" : "<a href=\"".adminlink($module_name. "&view=admin&menu=3")."\">"._CATADMIN_ADD."</a>") ." | "
		.($menu == 4 ? "<b>"._EVENTADMIN_PENDING . ($pending > 0 ? " ($pending)" : "(0)")."</b>" : "<a href=\"".adminlink($module_name. "&view=admin&menu=4")."\">"._EVENTADMIN_PENDING. ($pending > 0 ? " ($pending)" : "(0)") . "</a>")
		. "<br /><br />";


	if ($menu == 1)
		show_calendar_settings();
	elseif ($menu == 2)
		show_block_settings();
	elseif ($menu == 3)
		show_category_manager($catid);
	elseif ($menu == 4)
		show_pending_events($show);

	CloseTable();
	require_once("footer.php");
}

function show_pending_events($show) {
	global $module_name, $cal_config, $db, $cal_prefix, $bgcolor2, $prefix;
	$today = adodb_date ( "Ymd" );

	if (empty($show)) 
		$result = $db->sql_query ( "SELECT eid, creator, date, time, duration, type, view, name, description, image, category, approved FROM ". $cal_prefix ." WHERE approved = 0 or approved = $today");
	else if ($show == "all")
		$result = $db->sql_query ( "SELECT eid, creator, date, time, duration, type, view, name, description, image, category, approved FROM ". $cal_prefix);

	echo open_form(adminlink($module_name. "&view=approve_events"), "approveeventsform", _EVENTADMIN_PENDING);

	if ($db->sql_numrows($result) > 0) {
//	$result = $db->sql_query ( "SELECT eid, creator, date, time, duration, type, view, name, description, image, category FROM ". $cal_prefix,false,__FILE__,__LINE__ );
//	if ($result) {
		$calcategories = read_categories ( );

		echo "<table cellpadding=\"2\" cellspacing=\"3\" border=\"0\" width=\"50%\">\n\n"
			."<tr><td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._EVENTADMIN_APPROVE."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CALEVENTNAME."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._EVENTADMIN_OWNER."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CALSTARTDATE."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CALTIME."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CALCATEGORY."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CALVISIBLE."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CALPATTERN."</b></td>\n"
			."<td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CATADMIN_FUNCTIONS."</b></td></tr>\n";
		while($row = $db->sql_fetchrow($result)) {
			
			echo "<tr><td align=\"center\"><a href=\"".adminlink($module_name. "&view=approve_event&eid=$row[0]&approved=$row[11]")."\"><img src=\"".($row[11] > 0 ? "images/checked.gif" :  "images/unchecked.gif")."\" border=\"0\"></td>"
				."<td nowrap=\"nowrap\"><a href=\"".getlink($module_name. "&view=event&id=$row[0]&date=$row[2]")."\" title=\"$row[8]\">$row[7]</a></td>"
				."<td nowrap=\"nowrap\">$row[1]</td>"
				."<td>".substr ( $row[2], 4, 2 )."/".substr ( $row[2], 6, 2 )."/".substr ( $row[2], 0, 4 )."</td>"
				."<td nowrap=\"nowrap\">";
					$time = $row[3];
					$duration = $row[4];
					if ($time > 0) {
						echo display_time ( $time );
						if ( $duration > 0 ) {
							// calc end time
							$h = (int) ( $time / 10000 );
							$m = ( $time / 100 ) % 100;
							$m += $duration;
							$d = $duration;
							while ( $m >= 60 ) {
								$h++;
								$m -= 60;
							}
							echo " - " . display_time(sprintf ( "%02d%02d00", $h, $m ));
						}
					} else
						echo _ALLDAY;
				echo "</td>"
					."<td>".$calcategories[$row[10]]['title']."</td>"
					."<td nowrap=\"nowrap\">";
						$view = $row[6];
						if ($view == 0)
							$groupName = _MVALL;
						elseif ($view == 1)
							$groupName = _MVUSERS;
						elseif ($view == 2)
							$groupName = _MVADMIN;
						elseif ($view == 3)
							$groupName = _MVANON;
						elseif ($view >3)		 // <= phpBB User Groups Integration
							list($groupName) = $db->sql_ufetchrow("SELECT group_name FROM ".$prefix."_bbgroups WHERE group_id=".($view - 3), SQL_NUM, __FILE__, __LINE__);

						echo $groupName;
				echo "</td>"
				."<td nowrap=\"nowrap\">";
					$type = $row[5];
					if ($type == "R"){
						$res = $db->sql_query ( "SELECT eid, type, end, " .
						  "frequency, days FROM ".$cal_prefix."_repeat " .
						  "WHERE eid = ".$row[0]);
						if ( $res ) {
						  if ( $rrow = $db->sql_fetchrow ( $res ) ) {
							$rpt_type = $rrow[1];
							if ( $rrow[2] > 0 )
							  $rpt_end = date_to_epoch ( $rrow[2] );
							else
							  $rpt_end = 0;
							$rpt_end_date = $rrow[2];
							if ($rpt_end_date > 0) {
								$endyear = substr ( $rpt_end_date, 0, 4 );
								$endmonth = substr ( $rpt_end_date, 4, 2 );
								$endday = substr ( $rpt_end_date, 6, 2 );
							}
							$rpt_freq = $rrow[3];
							$rpt_days = $rrow[4];
							$byDay = array();
							if ($rpt_type == 'weekly') {
								$rpt_sun  = ( substr ( $rpt_days, 0, 1 ) == 'y' );
								$rpt_mon  = ( substr ( $rpt_days, 1, 1 ) == 'y' );
								$rpt_tue  = ( substr ( $rpt_days, 2, 1 ) == 'y' );
								$rpt_wed  = ( substr ( $rpt_days, 3, 1 ) == 'y' );
								$rpt_thu  = ( substr ( $rpt_days, 4, 1 ) == 'y' );
								$rpt_fri  = ( substr ( $rpt_days, 5, 1 ) == 'y' );
								$rpt_sat  = ( substr ( $rpt_days, 6, 1 ) == 'y' );
							} else if ($rpt_type == 'monthlyByDay') {
								$byDay = explode(",", $rpt_days);
								$rpt_select_option = $byDay[0];
								$rpt_select_day = $byDay[1];
							} else if ($rpt_type == 'yearlyByDay') {
								$byDay = explode(",", $rpt_days);
								$rpt_select_option = $byDay[0];
								$rpt_select_day = $byDay[1];
								$rpt_select_month = $byDay[2];
							}
						  }
						}
						$rpt_subtype = "";
						if ( $rpt_type == "monthlyByDay" ) {
							$rpt_type = "monthly";
							$rpt_subtype = "monthlyByDay";
						}
						if ( $rpt_type == "yearlyByDay" ) {
							$rpt_type = "yearly";
							$rpt_subtype = "yearlyByDay";
						}
						if ($rpt_type == 'daily')
							echo _CALEVERY . " " . $rpt_freq . " " . _CALDAYS;
						else if ($rpt_type == 'weekly') {
							echo _CALEVERY . " " . $rpt_freq . " " . _CALWEEKS . " ";
							echo $rpt_sun  == 'y' ? _SUNDAY." " : "";
							echo $rpt_mon  == 'y' ? _MONDAY." " : "";
							echo $rpt_tue  == 'y' ? _TUESDAY." " : "";
							echo $rpt_wed  == 'y' ? _WEDNESDAY." " : "";
							echo $rpt_thu  == 'y' ? _THURSDAY." " : "";
							echo $rpt_fri  == 'y' ? _FRIDAY." " : "";
							echo $rpt_sat  == 'y' ? _SATURDAY." " : "";
						} else if ($rpt_type == 'monthly') {
							echo _CALEVERY . " " . $rpt_freq . " " . _CALMONTHS . " ";
							if ($rpt_subtype == "monthlyByDay") {
								echo _CALONTHE . " " . ($rpt_select_option == "+1" ? _SECOND : $rpt_select_option) . " " . $rpt_select_day . " " . _CALOFTHEMONTH;
							}
						} else if ($rpt_type == 'yearly') {
							echo _CALEVERY . " " . $rpt_freq . " " . _CALYEARS . " ";
							if ($rpt_subtype == "yearlyByDay") {
								echo _CALONTHE . " " . ($rpt_select_option == "+1" ? _SECOND : $rpt_select_option) . " " . $rpt_select_day . " " . _CALOF . " " . month_name($rpt_select_month - 1);
							}
						}
						if ($rpt_end_date != 0) 
							echo " ". _CALENDINGBY." $endmonth/$endday/$endyear";
					} else
						echo _EVENTADMIN_NOREPEAT;
				echo "</td>"
					."<td nowrap=\"nowrap\" align=\"center\">[ <a href=\"".getlink($module_name. "&view=edit_event&id=$row[0]&date=$row[2]")."\">"._CATADMIN_EDIT."</a> | <a href=\"".adminlink($module_name. "&view=delete_event&eid=$row[0]")."\" onClick=\"return confirm('"._EVENTADMIN_DELETECONFIRM."');\">"._CATADMIN_DELETE."</a> ]</td>"
					."</tr>\n";
		}
		echo "<tr><td align=\"left\" colspan=\"9\"><a href=\"".adminlink($module_name. "&view=approve_event&eid=all&approved=0")."\"><img src=\"images/checked.gif\" border=\"0\">"._EVENTADMIN_APPROVEALL."</a></td></tr>";

		echo "</table>\n";


	} else 
		echo _EVENTADMIN_NOEVENTS;

	echo "<br /><br /><a href=\"".adminlink($module_name. "&view=admin&menu=4&show=all")."\">"._EVENTADMIN_ALLEVENTS."</a>";
	echo close_form();
}

function show_category_manager($catid) {
	global $module_name, $cal_config, $db, $cal_prefix, $bgcolor2;
	$title = "";
	$image = "blank.gif";
	$priority = 2;
	$display = 0;
	$image_dir = "modules/$module_name/images/";
	$pic_array = array();

	echo open_form(adminlink($module_name. "&view=save_category"), "addcategoryform", _CATADMIN_ADD);

	$result = $db->sql_query ( "SELECT CATID, TITLE, IMAGE FROM ". $cal_prefix ."_categories ORDER BY TITLE");
	if ($result) {
		echo "<table cellpadding=\"0\" cellspacing=\"3\" border=\"0\" width=\"50%\">\n"
			."<tr><td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CATADMIN_DEFAULT."</b></td><td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CATADMIN_TITLE."</b></td><td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CATADMIN_IMAGE."</b></td><td align=\"center\" bgcolor=\"".$bgcolor2."\"><b>"._CATADMIN_FUNCTIONS."</b></td></tr>\n";
		while(list($listid, $listtitle, $listimage) = $db->sql_fetchrow($result)) {
			echo "<tr><td align=\"center\"><a href=\"".adminlink($module_name. "&view=change_default&default=$listtitle")."\"><img ".($listtitle == $cal_config['default_category'] ? "src=\"images/checked.gif\" alt=\""._CATADMIN_CHECKED."\"" : "src=\"images/unchecked.gif\" alt=\""._CATADMIN_UNCHECKED."\"")." border=\"0\" /></a></td>"
				."<td>".$listtitle."</td>"
				."<td><img src=\"$image_dir$listimage\" border=\"0\" alt=\""._CATADMIN_DEFAULT_IMAGE."\" /> $listimage</td>"
				."<td align=\"center\">[ <a href=\"".adminlink($module_name. "&view=admin&catid=$listid&menu=3")."\">"._CATADMIN_EDIT."</a> | <a href=\"".adminlink($module_name. "&view=delete_category&catid=$listid")."\">"._CATADMIN_DELETE."</a> ]</td>"
				."</tr>\n";
		}
		echo "</table><br /><br />\n";
	}
	$db->sql_freeresult($result);

	if ($catid > 0) {
		list($title, $image, $priority, $display) = $db->sql_ufetchrow ( "SELECT title, image, priority, display FROM ". $cal_prefix ."_categories WHERE catid = $catid",SQL_NUM,__FILE__,__LINE__ );
	}
	echo "<b>"._CATADMIN_TITLE.":</b><br />"
		."<input type=\"text\" name=\"cattitle\" value=\"$title"."\" /><br /><br/>\n";


	get_calendar_images($image_dir, $pic_array);

	echo "<b>"._CATADMIN_IMAGE.":</b><br />"
		."<select onChange=\"changeImage('".$image_dir."', document.addcategoryform.catimage.options[document.addcategoryform.catimage.options.selectedIndex].value);\" name=\"catimage\">\n";


	foreach ($pic_array as $picture) {
		echo "	<option value=\"$picture\"". (strcmp($image, $picture) == 0 ? " selected=\"selected\"" : "") . ">$picture</option>\n";
	} 
	echo "</select> <img src=\"$image_dir$image\" name=\"sample\" alt=\""._CATADMIN_SAMPLE_IMAGE."\" /><br /><br />"
		."<b>"._CATADMIN_PRIORITY."</b><br />"
		."<select name=\"catpriority\">"
		."	<option value=\"1\"". ( $priority == 1 ? " selected=\"selected\"": "").">Low</option>"
		."	<option value=\"2\"". ( $priority == 2 ? " selected=\"selected\"": "").">Medium</option>"
		."	<option value=\"3\"". ( $priority == 3 ? " selected=\"selected\"": "").">High</option>"
		."</select><br /><br />"
		."<input type=\"checkbox\" name=\"catdefault\" value=\"1\"". ( $title == $cal_config['default_category'] ? " checked=\"checked\"": "")." />"._CATADMIN_DEFAULT._CATADMIN_DEFAULTCATEGORY."<br /><br />\n"
		."<input type=\"checkbox\" name=\"catdisplay\" value=\"1\"". ( $display == 1 ? " checked=\"checked\"": "")." />"._CATADMIN_DISPLAY."<br /><br />\n"
		."<input type=\"hidden\" name=\"catid\" value=\"$catid\" />\n"
		."<input type=\"submit\" value=\""._CALSAVE."\" />\n";

	echo close_form();
}

function show_calendar_settings() {
	global $module_name, $cal_config, $db, $cal_prefix, $bgcolor2;

	echo open_form(adminlink($module_name. '&amp;view=save_admin'), 'editadminform', _CALADMIN);

	echo "<table cellpadding=\"0\" cellspacing=\"3\" border=\"0\">\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_VIEW.":</b> </td><td><select name=\"defaultview\">\n"
		."	<option value=\"day\"". ($cal_config['default_view'] == "day" ? " selected=\"selected\"" : "") . ">"._CALDAILY." "._CALENDAR."</option>"
		."	<option value=\"week\"". ($cal_config['default_view'] == "week" ? " selected=\"selected\"" : "") . ">"._CALWEEKLY." "._CALENDAR."</option>"
		."	<option value=\"month\"". ($cal_config['default_view'] == "month" ? " selected=\"selected\"" : "") . ">"._CALMONTHLY." "._CALENDAR."</option>"
		."	<option value=\"year\"". ($cal_config['default_view'] == "year" ? " selected=\"selected\"" : "") . ">"._CALYEARLY." "._CALENDAR."</option>"
		."</select></td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_WEEKSTART.":</b> </td><td><select name=\"weekstart\">\n"
		."	<option value=\"0\"". ($cal_config['week_start_day'] == 0 ? " selected=\"selected\"" : "") . ">"._SUNDAY."</option>"
		."	<option value=\"1\"". ($cal_config['week_start_day'] == 1 ? " selected=\"selected\"" : "") . ">"._MONDAY."</option>"
		."</select></td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_TIMEFORMAT.":</b> </td><td><select name=\"timeformat\">\n"
		."	<option value=\"12\"". ($cal_config['time_format'] == 12 ? " selected=\"selected\"" : "") . ">"._CALADMIN_12HR."</option>"
		."	<option value=\"24\"". ($cal_config['time_format'] == 24 ? " selected=\"selected\"" : "") . ">"._CALADMIN_24HR."</option>"
		."</select></td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_WEEKLY.":</b> </td><td><input type=\"checkbox\" name=\"displayweekly\" value=\"1\" ".($cal_config['show_weekly_link'] == 1 ? "checked=\"checked\"" : "")." /></td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_SHOWHOURS.":</b> </td><td><input type=\"checkbox\" name=\"displayhours\" value=\"1\" ".($cal_config['show_time'] == 1 ? "checked=\"checked\"" : "")." /></td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_STARTYEAR.":</b> </td><td><input type=\"text\" name=\"startyear\" value=\"".(empty($cal_config['start_year']) ? "1900" : $cal_config['start_year'])."\" size=\"4\" /></td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_WORKDAYSTART.":</b> </td><td><input type=\"text\" name=\"workdaystart\" value=\"". $cal_config['workday_start'] ."\" size=\"2\" />"._CALADMIN_IN24FORMAT._CALADMIN_MIN_START_HOUR."</td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_WORKDAYEND.":</b> </td><td><input type=\"text\" name=\"workdayend\" value=\"". $cal_config['workday_end'] ."\" size=\"2\" />"._CALADMIN_IN24FORMAT._CALADMIN_MAX_END_HOUR."</td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_GROUP.":</b> </td><td>".group_selectbox('update', $cal_config['update'], false, false)."</td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_GROUP2.":</b> </td><td>".group_selectbox('adminevents', $cal_config['admin_events'], false, false)."</td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_APPROVAL.":</b> </td><td><input type=\"checkbox\" name=\"adminapproval\" value=\"1\" ".($cal_config['admin_approval'] == 1 ? "checked=\"checked\"" : "")." /></td></tr>\n"
		."<tr><td align=\"right\"><b>"._CALADMIN_YEAR.":</b> </td><td><input type=\"text\" name=\"yearcolumns\" value=\"".(empty($cal_config['year_columns']) ? "3" : $cal_config['year_columns'])."\" size=\"1\" />"._CALADMIN_MAX_YEAR_COLS."</td></tr>\n"
		."</table>\n"
		."<input type=\"submit\" value=\""._CALSAVE."\" />\n";
//		."</form>\n";
	echo close_form();
}

function show_block_settings() {
	global $module_name, $cal_config, $db, $cal_prefix, $bgcolor2;

	//echo "<form action=\"". adminlink($module_name. "&view=save") . "\" method=\"post\" name=\"editadminform\">\n";
	echo open_form(adminlink($module_name. "&view=save_block"), "editblockform", _CALBLOCKADMIN);

	echo "<table cellpadding=\"0\" cellspacing=\"3\" border=\"0\">\n"
		."<tr><td><fieldset ><legend>"._CALBLOCKUPCOMING."</legend>"
		."<table cellpadding=\"2\" cellspacing=\"3\" border=\"0\">"
		."<tr><td align=\"right\" nowrap=\"nowrap\"><b>"._CALBLOCKDISPLAYDAYS.":</b></td><td><input type=\"text\" name=\"upcomingdays\" value=\"".(empty($cal_config['block_upcoming_days']) ? "10" : $cal_config['block_upcoming_days'])."\" size=\"4\" /></td></tr>"
		."<tr><td align=\"right\" nowrap=\"nowrap\"><b>"._CALBLOCKSCROLLEVENTS.":</b></td><td><input type=\"checkbox\" name=\"upcomingscroll\" value=\"1\" ".($cal_config['block_upcoming_scroll'] == 1 ? "checked=\"checked\"" : "")." /></td></tr>"
		."<tr><td align=\"right\" nowrap=\"nowrap\"><b>"._CALBLOCKSCROLLSPEED.":</b></td><td><input type=\"text\" name=\"upcomingscrollspeed\" value=\"".(empty($cal_config['block_upcoming_scroll_speed']) ? "0" : $cal_config['block_upcoming_scroll_speed'])."\" size=\"4\" /></td></tr>"
		."</table></fieldset>"
		."</td></tr>\n"
		."<tr><td><fieldset ><legend>"._CALBLOCKSMALLMONTH."</legend>"
		."<table cellpadding=\"0\" cellspacing=\"3\" border=\"0\">"
		."<tr><td align=\"right\" nowrap=\"nowrap\"><b>"._CALBLOCKHIGHLIGHTDAYS.":</b></td><td><input type=\"checkbox\" name=\"highlightdays\" value=\"1\" ".($cal_config['block_month_highlight_days'] == 1 ? "checked=\"checked\"" : "")." /></td></tr>"
		."</table>"
		."</fieldset>"
		."</td></tr>\n"
		."</table>\n"
		."<input type=\"submit\" value=\""._CALSAVE."\" />\n";
	echo close_form();
}

function save_admin($defaultview, $weekstart, $timeformat, $displayweekly, $displayhours, $startyear, $workdaystart, $workdayend, $update, $adminapproval, $adminevents, $yearcolumns) {
	global $module_name, $cal_config, $prefix, $db;

	if ($workdaystart > $workdayend)
		cpg_error(_CALADMIN_WORKDAY_ERROR);

	$sql = "UPDATE " . $prefix . "_config_custom SET ";

	if ($cal_config['default_view'] != $defaultview) {
		$db->sql_query ( $sql . "cfg_value = '$defaultview' WHERE cfg_name = '$module_name' AND cfg_field = 'default_view'");
	}
	if ($cal_config['week_start_day'] != $weekstart) {
		$db->sql_query ( $sql."cfg_value = '$weekstart' WHERE cfg_name = '$module_name' AND cfg_field = 'week_start_day'");
	}
	if ($cal_config['time_format'] != $timeformat) {
		$db->sql_query ( $sql."cfg_value = '$timeformat' WHERE cfg_name = '$module_name' AND cfg_field = 'time_format'");
	}
	if ($cal_config['show_weekly_link'] != $displayweekly) {
		$db->sql_query ( $sql."cfg_value = '$displayweekly' WHERE cfg_name = '$module_name' AND cfg_field = 'show_weekly_link'");
	}
	if ($cal_config['show_time'] != $displayhours) {
		$db->sql_query ( $sql."cfg_value = '$displayhours' WHERE cfg_name = '$module_name' AND cfg_field = 'show_time'");
	}
	if ($cal_config['start_year'] != $startyear) {
		$db->sql_query ( $sql."cfg_value = '$startyear' WHERE cfg_name = '$module_name' AND cfg_field = 'start_year'");
	}
	if ($cal_config['workday_start'] != $workdaystart) {
		if ($workdayend < 0)
			$workdayend = 0;
		$db->sql_query ( $sql."cfg_value = '$workdaystart' WHERE cfg_name = '$module_name' AND cfg_field = 'workday_start'");
	}
	if ($cal_config['workday_end'] != $workdayend) {
		if ($workdayend > 23)
			$workdayend = 23;
		$db->sql_query ( $sql."cfg_value = '$workdayend' WHERE cfg_name = '$module_name' AND cfg_field = 'workday_end'");
	}
	if ($cal_config['update'] != $update) {
		$db->sql_query ( $sql."cfg_value = '$update' WHERE cfg_name = '$module_name' AND cfg_field = 'update'");
	}
	if ($cal_config['admin_approval'] != $adminapproval) {
		$db->sql_query ( $sql."cfg_value = '$adminapproval' WHERE cfg_name = '$module_name' AND cfg_field = 'admin_approval'");
	}
	if ($cal_config['admin_events'] != $adminevents) {
		$db->sql_query ( $sql."cfg_value = '$adminevents' WHERE cfg_name = '$module_name' AND cfg_field = 'admin_events'");
	}
	if ($cal_config['year_columns'] != $yearcolumns) {
		if ($yearcolumns > 6)
			$yearcolumns = 6;
		$db->sql_query ( $sql."cfg_value = '$yearcolumns' WHERE cfg_name = '$module_name' AND cfg_field = 'year_columns'");
	}

	Cache::array_delete('MAIN_CFG');

	url_redirect(adminlink($module_name . "&view=admin&menu=1"));
}

function save_block($upcomingdays, $upcomingscroll, $upcomingscrollspeed, $highlightdays) {
	global $module_name, $cal_config, $prefix, $db;

	$sql = "UPDATE " . $prefix . "_config_custom SET ";

	if ($cal_config['block_upcoming_days'] != $upcomingdays) {
		$db->sql_query ( $sql . "cfg_value = '$upcomingdays' WHERE cfg_name = '$module_name' AND cfg_field = 'block_upcoming_days'");
	}
	if ($cal_config['block_upcoming_scroll'] != $upcomingscroll) {
		$db->sql_query ( $sql . "cfg_value = '$upcomingscroll' WHERE cfg_name = '$module_name' AND cfg_field = 'block_upcoming_scroll'");
	}
	if ($cal_config['block_upcoming_scroll_speed'] != $upcomingscrollspeed) {
		$db->sql_query ( $sql . "cfg_value = '$upcomingscrollspeed' WHERE cfg_name = '$module_name' AND cfg_field = 'block_upcoming_scroll_speed'");
	}
	if ($cal_config['block_month_highlight_days'] != $highlightdays) {
		$db->sql_query ( $sql . "cfg_value = '$highlightdays' WHERE cfg_name = '$module_name' AND cfg_field = 'block_month_highlight_days'");
	}

	Cache::array_delete('MAIN_CFG');

	url_redirect(adminlink($module_name . "&view=admin&menu=2"));
}

function save_category($catid, $cattitle, $catimage, $catpriority, $catdefault, $catdisplay) {
	global $module_name, $cal_config, $db, $cal_prefix;
	if ($catdefault == 1) {
		change_default($cattitle);
	}
	if ($catid == 0)
		$result = $db->sql_query ( "INSERT INTO ". $cal_prefix ."_categories ( CATID, TITLE, IMAGE, PRIORITY, DISPLAY ) VALUES (NULL, '$cattitle', '$catimage', $catpriority, $catdisplay)");
	else
		$result = $db->sql_query ( "UPDATE ". $cal_prefix ."_categories SET TITLE = '$cattitle', IMAGE = '$catimage', PRIORITY = $catpriority, DISPLAY = $catdisplay WHERE CATID = $catid");

	if ( $db->sql_affectedrows( $result ) <= 0 )
		cpg_error(_CATADMIN_ERROR);

	url_redirect(adminlink($module_name . "&view=admin&menu=3"));
}

function change_default($title) {
	global $module_name, $db, $prefix;

	$result = $db->sql_query ( "UPDATE ". $prefix ."_config_custom SET cfg_value = '$title' WHERE cfg_name = '$module_name' AND cfg_field = 'default_category'");

	Cache::array_delete('MAIN_CFG');

	url_redirect(adminlink($module_name . "&view=admin&menu=3"));
}

function delete_category($catid) {
	global $module_name, $cal_config, $db, $cal_prefix;
	
	$result = $db->sql_query ( "DELETE FROM ". $cal_prefix ."_categories WHERE CATID = $catid");

	if ( $db->sql_affectedrows( $result ) <= 0 )
		cpg_error(_CATADMIN_ERROR);

	url_redirect(adminlink($module_name . "&view=admin&menu=3"));
}

function approve_event($eid, $approved) {
	global $module_name, $db, $cal_prefix;

	$today = adodb_date ( "Ymd" );

	if ($eid == "all") //approve all events
		$result = $db->sql_query ( "UPDATE ". $cal_prefix ." SET approved = $today WHERE approved = 0");
	else
		if ($approved == 0) //approve the event
			$result = $db->sql_query ( "UPDATE ". $cal_prefix ." SET approved = $today WHERE eid = $eid");
		else //deny the event
			$result = $db->sql_query ( "UPDATE ". $cal_prefix ." SET approved = 0 WHERE eid = $eid");


	url_redirect(adminlink($module_name . "&view=admin&menu=4"));
}

function delete_event( $id ) {
	global $cal_prefix, $db, $module_name;
	if ( ! empty ( $id ) ) {
		$db->sql_query ( "DELETE FROM " .$cal_prefix. " WHERE eid = $id");
		$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat WHERE eid = $id");
		$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat_cancel WHERE eid = $id");
		$db->sql_query ( "DELETE FROM " .$cal_prefix. "_repeat_desc WHERE eid = $id");
	}

	url_redirect(adminlink($module_name . "&view=admin&menu=4"));
}


if (isset($_GET['catid']))
	$catid = $_GET['catid'];
else
	$catid = 0;

if (isset($_GET['menu']))
	$menu = $_GET['menu'];
else
	$menu = 1;

if (isset($_GET['view']))
	$view = $_GET['view'];
else
	$view = "admin";

if (isset($_GET['show']))
	$show = $_GET['show'];
else
	$show = "";

switch ($view) {
	case "approve_event":
		approve_event($_GET['eid'], $_GET['approved']);
		break;

	case "delete_event":
		delete_event($_GET['eid']);
		break;

	case "save_category":
		save_category($_POST['catid'], $_POST['cattitle'], $_POST['catimage'], $_POST['catpriority'], isset($_POST['catdefault'])?$_POST['catdefault']:'', isset($_POST['catdisplay'])?$_POST['catdisplay']:'0' );
		break;

	case "delete_category":
		delete_category($catid);
		break;

	case "change_default":
		change_default($_GET['default']);
		break;

	case "save_admin":
		save_admin($_POST['defaultview'], $_POST['weekstart'], $_POST['timeformat'], isset($_POST['displayweekly'])?$_POST['displayweekly']:"",
		isset($_POST['displayhours'])?$_POST['displayhours']:"", 
		$_POST['startyear'], 
		empty($_POST['workdaystart']) ? 0 : $_POST['workdaystart'], 
		empty($_POST['workdayend']) ? 24 : $_POST['workdayend'], 
		$_POST['update'], $_POST['adminapproval'], $_POST['adminevents'], $_POST['yearcolumns']);
		break;

	case "save_block":
		save_block($_POST['upcomingdays'], 
					isset($_POST['upcomingscroll'])?$_POST['upcomingscroll']:"0",
					!empty($_POST['upcomingscrollspeed'])?$_POST['upcomingscrollspeed']:"0",
					isset($_POST['highlightdays'])?$_POST['highlightdays']:"0");
		break;

	case "admin":
			view_admin($catid, $menu, $show);
		break;
}
