<?php
/*********************************************
  CPG-Nuke Event Calendar
  ********************************************
  Copyright 2005 by Kris Henneman
  
  Original highly modified code ported from an early 2003 
  version of WebCalendar by http://webcalendar.sourceforge.net
  to PHP-Nuke.  It has since been ported to CPG-Nuke.

  Calendar is released under the terms and conditions
  of the GNU GPL version 2 or any later version

  $Id: block-CPGNuCalendar_Small_Month.php,v 1.1 2007/10/21 13:04:04 Phoenix Exp $
  $RCSfile: block-CPGNuCalendar_Small_Month.php,v $
  $Revision: 1.1 $
  $Author: Phoenix $
  $Date: 2007/10/21 13:04:04 $
**********************************************/

if (!defined('CPG_NUKE')) { exit; }

$cal_module_name = "CPGNuCalendar";
require_once("modules/$cal_module_name/includes/functions.inc");

global $cal_prefix, $cal_config, $cal_module_name, $canceled_events, $repeated_events, $events, $bgcolor1, $bgcolor2;

get_lang($cal_module_name, __FILE__, __LINE__);

if (!is_active($cal_module_name)) {
    $content = $cal_module_name." "._CALINACTIVE;
    return;
}

$year = date("Y");
$month = date("m");

/*****************************************
	Code to enable highlighted dates
******************************************/

if ($cal_config['block_month_highlight_days'] == 1) {
	$startdate = sprintf ( "%04d%02d01", $year, $month );
	$enddate = sprintf ( "%04d%02d31", $year, $month );

	/* Pre-Load the canceled repeating events for quckier access */
	$canceled_events = read_canceled_events ( $startdate, $enddate );
	/* Pre-Load the repeated events for quckier access */
	$repeated_events = read_repeated_events ();
	/* Pre-load the non-repeating events for quicker access */
	$events = read_events ( $startdate, $enddate );
}
/*****************************************/

$content = '<table border="0" cellpadding="0" cellspacing="0" width="100%">';
if ( $cal_config['week_start_day'] == "1" )
	$wkstart = get_monday_before ( $year, $month, 1 );
else
	$wkstart = get_sunday_before ( $year, $month, 1 );
$monthstart = mktime ( 0, 0, 0, $month, 1, $year );
$monthend = mktime ( 0, 0, 0, $month + 1, 0, $year );
$content .= "<tr><td colspan=\"7\" class=\"cat\" align=\"center\">" .
	"<a href=\"".getlink($cal_module_name."&amp;view=month&amp;month=$month&amp;year=$year")."\">";
$content .= month_name ( $month - 1 ) . " " . $year;
$content .= "</a></td></tr>\n";
$content .= "<tr><td colspan=\"7\" style=\"background-color:".$bgcolor2.";\">";
$content .= '<table border="0" cellpadding="2" cellspacing="1" width="100%"><tr>';
if ( $cal_config['week_start_day'] == 0 )
	$content .= "<td align=\"center\" width=\"14.28%\">" . weekday_letter_name ( 0 ) . "</td>";
for ( $i = 1; $i < 7; $i++ ) {
	$content .= "<td align=\"center\" width=\"14.28%\">" .	weekday_letter_name ( $i ) . "</td>";
}
if ( $cal_config['week_start_day'] == 1 )
	$content .= "<td align=\"center\" width=\"14.28%\">" . weekday_letter_name ( 0 ) . "</td>";
$content .= "</tr>";

$today = mktime ( 2, 0, 0, date ( "m" ), date ( "d" ), date ( "Y" ) );
for ( $i = $wkstart; date ( "Ymd", $i ) <= date ( "Ymd", $monthend ); $i += ( 24 * 3600 * 7 ) ) {
	$content .= "<tr>\n";
	for ( $j = 0; $j < 7; $j++ ) {
		$date = $i + ( $j * 24 * 3600 );
		if ( date ( "Ymd", $date ) >= date ( "Ymd", $monthstart ) &&
			date ( "Ymd", $date ) <= date ( "Ymd", $monthend ) ) {
			if ($cal_config['block_month_highlight_days'] == 1) 
				$content .= "<td style=\"background-color:". (hasEvents(adodb_date ( "Ymd", $date )) ? $bgcolor2 : $bgcolor1) .";\" align=\"center\">";
			else
				$content .= "<td style=\"background-color:$bgcolor1;\" align=\"center\">";
			if ( date ( "Ymd", $date ) == date ( "Ymd", $today ) )
				 $content .= "<div id=\"Layer1\" align=\"left\" style=\"position:relative; width: 16px; height: 16px; background-image:url(modules/$cal_module_name/images/today.gif);\"><A href=\"".getlink($cal_module_name . "&amp;view=day&amp;date=".date ("Ymd", $date ) ) . "\">".date ( "d", $date ) . "</a></div>";
			else
				$content .= "<a href=\"".getlink($cal_module_name . "&amp;view=day&amp;date=".date ("Ymd", $date ) ) . "\">"
				.date ( "d", $date ) . "</a>";
			$content .= "</td>\n";
		} else {
			$content .= "<td style=\"background-color:$bgcolor1;\"></td>\n";
		}
	}
	$content .= "</tr>\n";
}
$content .= "</table></td></tr>";
$content .= "</table>\n";
