<?php
/*********************************************
  CPG-Nuke Event Calendar
  ********************************************
  Copyright 2005 by Kris Henneman
  
  Original highly modified code ported from an early 2003 
  version of WebCalendar by http://webcalendar.sourceforge.net
  to PHP-Nuke.  It has since been ported to CPG-Nuke.

  Calendar is released under the terms and conditions
  of the GNU GPL version 2 or any later version

  $Id: block-CPGNuCalendar-center-Coming_Events.php,v 1.1 2007/10/21 13:04:04 Phoenix Exp $
  $RCSfile: block-CPGNuCalendar-center-Coming_Events.php,v $
  $Revision: 1.1 $
  $Author: Phoenix $
  $Modified: Scott Arnold $
  $Date: 2007/10/21 13:04:04 $
**********************************************/

if (!defined('CPG_NUKE')) { exit; }

$cal_module_name = "CPGNuCalendar";

require_once("modules/$cal_module_name/includes/functions.inc");

global $cal_prefix, $cal_config, $cal_module_name, $repeated_descriptions, $canceled_events, $repeated_events, $events, $calcategories, $bgcolor1, $bgcolor2, $userinfo;

get_lang($cal_module_name, __FILE__, __LINE__);

if (!is_active($cal_module_name)) {
    $content = $cal_module_name." "._CALINACTIVE;
    return;
}

$year = date("Y");
$month = date("m");
$day = date("d");

$numdays = $cal_config['block_upcoming_days'];
$startdate = sprintf ( "%04d%02d%02d", $year, $month, $day );
$future = adodb_mktime( 0, 0, 0, $month, $day+$numdays, $year);
$enddate = adodb_date( "Ymd", $future);

/* Pre-Load the descriptions for repeating events for quckier access */
$repeated_descriptions = read_repeated_descriptions ( $startdate, $enddate );
/* Pre-Load the canceled repeating events for quckier access */
$canceled_events = read_canceled_events ( $startdate, $enddate );
/* Pre-Load the repeated events for quckier access */
$repeated_events = read_repeated_events ();
/* Pre-load the non-repeating events for quicker access */
$events = read_events ( $startdate, $enddate );
/* Pre-load the categories for quicker access */
$calcategories = read_categories ( );

$holdoutput = "";
$output = "";
$output2 = "";

$content = "";


for ( $d = 0; $d < $numdays; $d++ ) {
	$days[$d] = adodb_mktime( 0, 0, 0, $month, $day+$d, $year);
}

for ( $d = 0; $d < $numdays; $d++ ) {
	$date = adodb_date ( "Ymd", $days[$d] );
	$daysevents = print_month_events($date);

	$holdoutput .= "<tr><td style=\"background-color:$bgcolor2;\"><b>";
	$wday = adodb_strftime ( "%w", $days[$d] );
	$formateddate = adodb_date( remove_time($userinfo['user_dateformat']),  $days[$d]);
	$holdoutput .= $formateddate;
	//$output .= sprintf ( "%s, %s %d, %d<br />", weekday_name ( $wday ), month_short_name ( adodb_date( "m",  $days[$d]) - 1 ), adodb_date( "d",  $days[$d]), adodb_date( "Y",  $days[$d]) );
	$holdoutput .= "</b></td></tr>\n<tr><td style=\"background-color:$bgcolor1;\">";
	$holdoutput .= $daysevents;
	$holdoutput .= "</td></tr><tr><td>&nbsp;</td></tr>\n";

	if ( $daysevents != "" ) {
		if ($d <= round($numdays/2))
			$output .= $holdoutput;
		else 
			$output2 .= $holdoutput;
	}
	$holdoutput = "";
}

$content .= '<table width="100%" border="0"><tr><td width="10%">&nbsp;</td>';
$content .= '<td valign="top" align="center" width="35%">';

if ( $output != "" ) {
	$content .= '<table border="0" cellpadding="0" cellspacing="0" width="100%">';
	$content .= $output;
	$content .= "</table>\n";
	$content .= '</td><td width="10%">&nbsp;</td><td valign="top" align="center" width="35%">';

	$content .= '<table border="0" cellpadding="0" cellspacing="0" width="100%">';
	$content .= $output2;
	$content .= "</table>\n";
} else
	$content = sprintf(_CALNOEVENTS, $numdays); 

$content .= "</td>";
$content .= '<td width="10%">&nbsp;</td>';
$content .= "</tr></table>";
